##import numpy as np
import pandas as pd
import matplotlib.pyplot as plt
import seaborn as sns

##한글 폰트 깨짐 방지 
from matplotlib import font_manager, rc

font_path = "c:\\windows\\fonts\\malgun.ttf"
font_name = font_manager.FontProperties(fname=font_path).get_name()

rc('font', family=font_name)
###########################################

##차트 크기(단위는 인치로 계산됨)
plt.figure(figsize=(5,4))


## data 분석 자료. 탑승 클래스(1,2,3등급) 별 생존자와 사망자 수 분석 자료 
df = pd.read_csv('../data/titanic.csv', encoding='euc-kr')


## violinplot and boxplot [탑승클래스별 생존자와 사망자  나이 분포], [성별 생존자와 사망자 나이 분포]
sns.violinplot('Pclass', 'Age', hue='Survived', data=df, split=True, palette='OrRd')
plt.title('탑승클래스 별 생존자와 사망자의 나이 분포')  ##차트제목
plt.xlabel('탑승클래스')  ##x축 이름 
h=plt.ylabel('나\n이') ##y축 이름
h.set_rotation(0)

plt.show()
